﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using AntiXssEnc = Microsoft.Security.Application;
using System.Configuration;
using VIRP_WEB.BaseCode;
using VIRP.AHOBPR.BO;
using VIRP.AHOBPR.BLL;
using VIRP.CRS.BO;
using VIRP_WEB.Controls.Custom.BPR;

namespace VIRP_WEB.Custom.BPR.Admin
{
    public partial class MyAccountEditUser : BprBasePage
    {
        private ServiceInterfaceManager ahobprUserManager = new ServiceInterfaceManager();

        SoaServices.AHOBPR_USER ahobprUserEntry;
        string userName = "";
        int registryId = 0;
        SoaServices.USER_STATES_FILTER stateFilter = new SoaServices.USER_STATES_FILTER();
        private bool isOnlyAdvancedUser = false;

        #region Protected Methods
        protected override void Page_Load(object sender, EventArgs e)
        {
            SetPageVars();

            if (!IsPostBack)
            {
                string sChangeStatusStateFilter = "4";

                if (ConfigurationManager.AppSettings["ChangeStatusStateFilterLimit"] != null)
                {
                    sChangeStatusStateFilter = ConfigurationManager.AppSettings["ChangeStatusStateFilterLimit"].ToString();
                }

                SetupBaseControls(false);

                AlterPageForAdvancedUsers(sChangeStatusStateFilter);

                LoadControlsFromObject();
            }
        }

        protected void SetPageVars()
        {
            HiddenFieldUserID.Value = UserSession.CurrentUserId.ToString(); 
            userName = HttpContext.Current.User.Identity.Name;
            registryId = UserSession.CurrentRegistryId;
            isOnlyAdvancedUser = CheckIfUserHasAdvancedUserRole();
        }

        private void AlterPageForAdvancedUsers(string filterLimit)
        {
            //set class field as it will be referenced when saving the user
            SetVisibilityOfStateFilterDiv(isOnlyAdvancedUser, filterLimit);
        }

        private bool CheckIfUserHasAdvancedUserRole()
        {
            if (UserSession.IsRegistryUpdate && !UserSession.IsSystemAdministrator)
            {
                isOnlyAdvancedUser = true;
            }
            else
            {
                isOnlyAdvancedUser = false;
            }

            return isOnlyAdvancedUser;
        }

        private void SetVisibilityOfStateFilterDiv(bool isAdvancedUser, string filterLimit)
        {
            if (isOnlyAdvancedUser)
            {
                ListBoxState.Visible = true;
                StateFilterLimit.Text = filterLimit;
                UserControlListBoxState.IsRequired = true;
            }
            else
            {
                //DEBUGGING: Remove and find a better way to TEST
                ListBoxState.Visible = false;
                //todo put code in javascript that will pass by validation if limit set to 0
                //todo add button save functionality that will not submit state filter info if user isn't an advanced user
                StateFilterLimit.Text = "0";
                UserControlListBoxState.IsRequired = false;
            }
        }

        protected void getEntry(int id)
        {
            ahobprUserEntry = ahobprUserManager.AHOBPR_USER_GET(userName, registryId, id);

            if (ahobprUserEntry == null)
            {
                ServiceInterfaceManager.LogError("No AHOBPR User found for id: " + id.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }           
        }
        #endregion Protected Methods

        #region Object/Form Mapping
       
        private void LoadControlsFromObject()
        {
            getEntry(Convert.ToInt32(HiddenFieldUserID.Value));

            if (ahobprUserEntry != null &&
                ahobprUserEntry.USER_ID != 0)
            {
                txtUsername.Text = ahobprUserEntry.USER.USERNAME;
                txtFullName.Text = ahobprUserEntry.USER.FULL_NAME;
                txtFirstName.Text = ahobprUserEntry.USER.FIRST_NAME;
                txtMiddleName.Text = ahobprUserEntry.USER.MIDDLE_NAME;
                txtLastName.Text = ahobprUserEntry.USER.LAST_NAME;
                txtMaidenName.Text = ahobprUserEntry.USER.MAIDEN_NAME;
                txtEmployeeNumber.Text = ahobprUserEntry.USER.EMPLOYEE_NUMBER;
                txtJobTitle.Text = ahobprUserEntry.USER.JOB_TITLE;
                txtEmailAddress.Text = ahobprUserEntry.USER.EMAIL_ADDRESS;
                txtTelephoneNumber.Text = ahobprUserEntry.USER.TELEPHONE_NUMBER;
                txtFaxNumber.Text = ahobprUserEntry.USER.FAX_NUMBER;
                LabelCreatedOn.Text = Helpers.getShortDateStringFromNullableDate(ahobprUserEntry.USER.CREATED);
                LabelUpdatedOn.Text = Helpers.getShortDateStringFromNullableDate(ahobprUserEntry.USER.UPDATED);
                LabelLastLogin.Text = ahobprUserEntry.LAST_LOGIN == null ? "[None]" : ahobprUserEntry.LAST_LOGIN.Value.ToString();
                LabelLastVistaLogin.Text = ahobprUserEntry.LAST_VISTA_LOGIN == null ? "[None]" : ahobprUserEntry.LAST_VISTA_LOGIN.Value.ToString();
                chkEmailAlerts.Checked = ahobprUserEntry.USER.RECEIVE_EMAIL == null ? false : (bool)ahobprUserEntry.USER.RECEIVE_EMAIL;

                string createdBy = string.IsNullOrEmpty(ahobprUserEntry.USER.CREATEDBY) ? ahobprUserEntry.USER.USERNAME : ahobprUserEntry.USER.CREATEDBY;
                LabelCreatedBy.Text = AntiXssEnc.Encoder.HtmlEncode(createdBy);

                string updatedBy = string.IsNullOrEmpty(ahobprUserEntry.USER.UPDATEDBY) ? ahobprUserEntry.USER.USERNAME : ahobprUserEntry.USER.UPDATEDBY;
                LabelUpdatedBy.Text = AntiXssEnc.Encoder.HtmlEncode(updatedBy);

                //Status label, Activate & Approve buttons:
                if (ahobprUserEntry.ACTIVE_FLAG)
                {
                    if (ahobprUserEntry.PENDING_FLAG)
                    {
                        LabelStatus.Text = "Pending";
                    }
                    else
                    {
                        LabelStatus.Text = "Active";
                    }
                }
                else
                {
                    LabelStatus.Text = "Inactive";
                }

                //Primary Job, Secondary Job and Work Location
                BaseControlDropdownListPrimaryJob.Text = ahobprUserEntry.PRIMARY_JOB_ID.ToString();
                BaseControlDropdownListSecondaryJob.Text = ahobprUserEntry.SECONDARY_JOB_ID.ToString();
                BaseControlDropdownListWorkLocation.Text = ahobprUserEntry.WORK_LOCATION_ID.ToString();

                // user state filter
                //Only advanced users have the opportunity to select the states to filter on
                //The UserConotrolListBoxState won't be loaded for a non-advanced user, so
                // don't try to set that control
                if (isOnlyAdvancedUser)
                {
                    if (this.UserControlListBoxState.LookupList == null)
                    {
                        SetupBaseControls(true);
                    }

                    stateFilter = ahobprUserManager.GetUserStateFilter(userName, registryId, ahobprUserEntry.USER_ID);

                    if (stateFilter == null)
                    {
                        //USER isn't set up in this table, better create an entry to be saved later
                        stateFilter = new SoaServices.USER_STATES_FILTER
                        {
                            USER_ID = ahobprUserEntry.USER_ID,
                            STATES = ""
                        };
                    }

                    this.UserControlListBoxState.DataElementValue = Helpers.ConvertToKeyValuePair(stateFilter.STATES);
                }
            }
        }

        private void LoadObjectFromControls()
        {
            getEntry(Convert.ToInt32(HiddenFieldUserID.Value));

            ahobprUserEntry.USER.USERNAME = txtUsername.Text;
            ahobprUserEntry.USER.FULL_NAME = txtFullName.Text;
            ahobprUserEntry.USER.FIRST_NAME = txtFirstName.Text;
            ahobprUserEntry.USER.MIDDLE_NAME = txtMiddleName.Text;
            ahobprUserEntry.USER.LAST_NAME = txtLastName.Text;
            ahobprUserEntry.USER.MAIDEN_NAME = txtMaidenName.Text;
            ahobprUserEntry.USER.EMPLOYEE_NUMBER = txtEmployeeNumber.Text;
            ahobprUserEntry.USER.JOB_TITLE = txtJobTitle.Text;
            ahobprUserEntry.USER.EMAIL_ADDRESS = txtEmailAddress.Text;
            ahobprUserEntry.USER.TELEPHONE_NUMBER = txtTelephoneNumber.Text;
            ahobprUserEntry.USER.FAX_NUMBER = txtFaxNumber.Text;
            ahobprUserEntry.USER.RECEIVE_EMAIL = chkEmailAlerts.Checked;

            //Primary job, secondary job and work location
            if (ahobprUserEntry == null || ahobprUserEntry.USER_ID == 0)
            {
                ahobprUserEntry = new SoaServices.AHOBPR_USER();
                ahobprUserEntry.USER_ID = UserSession.CurrentUserId;
            }

            var primaryId = string.IsNullOrEmpty(BaseControlDropdownListPrimaryJob.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListPrimaryJob.Text);
            var secondaryId = string.IsNullOrEmpty(BaseControlDropdownListSecondaryJob.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListSecondaryJob.Text);
            var workLocation = string.IsNullOrEmpty(BaseControlDropdownListWorkLocation.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListWorkLocation.Text);

            ahobprUserEntry.PRIMARY_JOB_ID = primaryId;
            ahobprUserEntry.SECONDARY_JOB_ID = secondaryId;
            ahobprUserEntry.WORK_LOCATION_ID = workLocation;

            //Only advanced users have the opportunity to select the states to filter on
            if (isOnlyAdvancedUser)
            {
                stateFilter.USER_ID = Convert.ToInt32(HiddenFieldUserID.Value);
                stateFilter.STATES = UserControlListBoxState.Text;
            }
        }
        #endregion

        #region Postback Events

        protected void ButtonSave_Click(object sender, EventArgs e)
        {
            LoadObjectFromControls();

            ahobprUserManager.AHOBPRUSERS_SAVE(userName, registryId, ahobprUserEntry);

            //Only advanced users have the opportunity to select the states to filter on
            //If the user doesn't have the advanced users role, don't make a call to the DB

            if (isOnlyAdvancedUser)
            {
                ahobprUserManager.SaveUserStateFilter(userName, registryId, stateFilter);
            }

            LoadControlsFromObject();

            Alert.ShowSaveSuccess();
        }

        protected void ButtonCancel_Click(object sender, EventArgs e)
        {
            LoadControlsFromObject();
        }
        #endregion

        private void SetupBaseControls(bool loadOnlyStatesFilter)
        {
            List<STD_GUI_CONTROLS> sgcs = VIRP.CRS.BLL.STD_GUI_CONTROLSManager.GetByCategory(userName, registryId, "AHOBPR_MYACCOUNT_ACCOUNTINFORMATION");

            foreach(STD_GUI_CONTROLS dbItem in sgcs)
            {
                Control userControl = pnlUserContainer.FindControl(dbItem.USER_CONTROL_ID);

                if (userControl != null)
                {
                    switch (dbItem.BASE_CONTROL_TYPE)
                    {
                        case (int)AhobprBaseControlType.DropDownList:

                            if (!loadOnlyStatesFilter)
                            {
                                controls_BaseControlDropDownList bcddl = (controls_BaseControlDropDownList)userControl;
                                bcddl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                   dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                            }
                            break;

                        case (int)AhobprBaseControlType.ListBox:

                            if (isOnlyAdvancedUser)
                            {
                                controls_UserControlListBoxState baseControl = (controls_UserControlListBoxState)userControl;
                                baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                                        dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                            }
                            break;
                    }
                }
            }
        }

        public override string TopMenuName()
        {
            return "My Account";
        }

        public override string MenuItemName()
        {
            return "Account Information";
        }

        public override string AppObjectCode()
        {
            return "AHOBPR MY ACCOUNT";
        }
    }
}